<?php
if ( ! defined( 'ABSPATH' ) ) exit;

if ( isset( $_GET['settings-updated'] ) ) {
	add_settings_error( 'rpm_messages', 'rpm_message', 'Settings saved successfully.', 'updated' );
}
settings_errors( 'rpm_messages' );

// No longer using queue - posts are generated on-the-fly
$rpm_test_nonce = wp_create_nonce( 'rpm_test_fastapi' );
$rpm_api_key = esc_js( get_option( 'rpm_api_key', '' ) );
?>
<div class="wrap">
	<h1 class="wp-heading-inline">
		<span class="dashicons dashicons-admin-generic" style="font-size: 28px; width: 28px; height: 28px; vertical-align: middle;"></span>
		<?php echo esc_html( get_admin_page_title() ); ?>
	</h1>
	<p class="description" style="margin-top: 10px; font-size: 14px;">Configure your FastAPI connection, subscription details, and auto-posting schedule.</p>
	
	<hr class="wp-header-end">
	
	<!-- Quick Setup with Code Section -->
	<div style="background: #fff; padding: 20px; margin: 20px 0; border-left: 4px solid #4facfe; box-shadow: 0 1px 3px rgba(0,0,0,0.1); max-width: 800px;">
		<h2 style="margin-top: 0; color: #4facfe;">⚡ Quick Setup with Code</h2>
		<p>Have a setup code from your subscription? Enter it below to automatically configure everything!</p>
		
		<div style="display: flex; gap: 10px; align-items: flex-start; max-width: 500px;">
			<div style="flex: 1;">
				<input 
					type="text" 
					id="rpm_setup_code" 
				placeholder="000000" 
				maxlength="6"
				pattern="[0-9]{6}"
				style="width: 100%; font-size: 28px; letter-spacing: 8px; text-align: center; font-family: monospace; border: 2px solid #ddd; border-radius: 4px;"
			/>
				<p id="code-status" style="margin: 5px 0 0 0; font-size: 12px; color: #666; text-align: center;"></p>
			</div>
			<button 
				type="button" 
				id="rpm_verify_code" 
				class="button button-primary button-large"
				style="height: 56px; background: #4facfe; border-color: #4facfe; font-size: 16px; padding: 0 20px;"
			>
				✓ Verify
			</button>
		</div>
		
		<div id="code-result" style="margin-top: 15px;"></div>
	</div>
	
	<hr style="margin: 30px 0;">
	<p>Configure connection to the FastAPI AI content generation service.</p>
	
	<form action="options.php" method="post">
		<?php settings_fields( 'rpm_fastapi_group' ); ?>
		
		<table class="form-table">
			<tr>
				<th scope="row"><label for="rpm_fastapi_url">FastAPI URL</label></th>
				<td>
					<input type="text" id="rpm_fastapi_url" name="rpm_fastapi_url" value="<?php echo esc_attr( get_option( 'rpm_fastapi_url', 'https://findexa.ca/api' ) ); ?>" class="regular-text" placeholder="https://findexa.ca/api" />
					<p class="description">URL of the FastAPI server (e.g., https://findexa.ca/api or https://api.yourdomain.com)</p>
				</td>
			</tr>
			<tr>
				<th scope="row"><label for="rpm_fastapi_key">FastAPI API Key</label></th>
				<td>
					<input type="text" id="rpm_fastapi_key" name="rpm_fastapi_key" value="<?php echo esc_attr( get_option( 'rpm_fastapi_key', '' ) ); ?>" class="regular-text" placeholder="fxa_..." />
					<p class="description">Your FastAPI Bearer token (starts with fxa_)</p>
					<?php 
					$fastapi_key = get_option( 'rpm_fastapi_key', '' );
					if ( ! empty( $fastapi_key ) ): ?>
						<p class="description" style="color: #00a32a;"><strong>✓</strong> FastAPI key is configured.</p>
					<?php else: ?>
						<p class="description" style="color: #d63638;"><strong>!</strong> No FastAPI key set. Enter your key to enable AI content generation.</p>
					<?php endif; ?>
				</td>
			</tr>
			<tr>
				<th scope="row">Connection Test</th>
				<td>
					<button type="button" id="rpm_test_fastapi" class="button">Test FastAPI Connection</button>
					<div id="rpm_fastapi_test_result" style="margin-top: 10px;"></div>
				</td>
			</tr>
		</table>
		
	<?php submit_button( 'Save FastAPI Settings' ); ?>
</form>

<hr>
<!-- Subscription Details Section -->
	<h2 class="title">📊 Subscription Details</h2>
	<p>Your current subscription plan and usage information.</p>
	
	<div id="rpm-subscription-details" style="margin: 20px 0;">
		<p style="text-align: center; padding: 40px 20px; background: #f0f6fc; border-radius: 4px;">
			<span class="spinner is-active" style="float: none; margin: 0 10px 0 0;"></span>
			Loading subscription information...
		</p>
	</div>
	
	<script>
	jQuery(document).ready(function($) {
		// Fetch subscription details when page loads
		function loadSubscriptionDetails() {
			var fastapi_url = $('#rpm_fastapi_url').val();
			var fastapi_key = $('#rpm_fastapi_key').val();
			
			if (!fastapi_url || !fastapi_key) {
				$('#rpm-subscription-details').html(
					'<div class="notice notice-warning inline">' +
					'<p>⚠️ Please configure FastAPI URL and API Key above to view subscription details.</p>' +
					'</div>'
				);
				return;
			}
			
			$.ajax({
				url: ajaxurl,
				type: 'POST',
				data: {
					action: 'findexa_check_subscription',
					nonce: '<?php echo wp_create_nonce( 'findexa_subscription_check' ); ?>'
				},
				timeout: 10000,
				success: function(response) {
					if (response.success && response.data) {
						var data = response.data;
						var html = '<div class="card" style="max-width: 800px; padding: 20px; background: #fff; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">';
						
						// Plan name (dynamic - any plan name works)
						var planName = data.subscription_plan ? data.subscription_plan.charAt(0).toUpperCase() + data.subscription_plan.slice(1) : 'Free';
						var statusColor = data.subscription_status === 'active' ? '#00a32a' : '#d63638';
						var daysLeft = data.days_remaining_in_cycle || 31;
						
						html += '<h3 style="margin-top: 0;">Current Plan: <span style="color: ' + statusColor + ';">' + planName + '</span></h3>';
						html += '<p style="font-size: 14px; color: #666; margin-bottom: 20px;">Status: <strong style="color: ' + statusColor + ';">' + (data.subscription_status || 'inactive') + '</strong> &nbsp;|&nbsp; <strong>' + daysLeft + ' day' + (daysLeft !== 1 ? 's' : '') + '</strong> left in billing cycle</p>';
						
					// Limits (dynamic - works with any limit structure)
				// Use 3 columns if topups exist, otherwise 2
				var hasTopups = typeof data.topup_posts !== 'undefined';
				var gridCols = hasTopups ? '3' : '2';
					html += '<div style="display: grid; grid-template-columns: repeat(' + gridCols + ', 1fr); gap: 20px; margin-bottom: 20px;">';
					
					// Daily limits
					html += '<div style="padding: 15px; background: #f0f6fc; border-radius: 4px;">';
					html += '<h4 style="margin: 0 0 10px 0; font-size: 14px; color: #666;">Daily Limit</h4>';
					html += '<p style="margin: 0; font-size: 28px; font-weight: bold; color: #2271b1;">' + (data.posts_per_day || 0) + '</p>';
					html += '<p style="margin: 5px 0 0 0; font-size: 12px; color: #666;">posts per day</p>';
					html += '</div>';
					
					// Monthly limits
					if (data.posts_per_month) {
						html += '<div style="padding: 15px; background: #f0f6fc; border-radius: 4px;">';
						html += '<h4 style="margin: 0 0 10px 0; font-size: 14px; color: #666;">Monthly Limit</h4>';
						html += '<p style="margin: 0; font-size: 28px; font-weight: bold; color: #2271b1;">' + data.posts_per_month + '</p>';
						html += '<p style="margin: 5px 0 0 0; font-size: 12px; color: #666;">posts per month</p>';
						html += '</div>';
					}
					
				// TopUp posts (3rd box)
				if (hasTopups) {
					html += '<div style="padding: 15px; background: #fff3cd; border-radius: 4px;">';
					html += '<h4 style="margin: 0 0 10px 0; font-size: 14px; color: #856404;">🎫 TopUp Posts</h4>';
					html += '<p style="margin: 0; font-size: 28px; font-weight: bold; color: #856404;">' + (data.topup_posts || 0) + '</p>';
					
					// Add TopUp button if 0 topups
					if (!data.topup_posts || data.topup_posts === 0) {
						html += '<p style="margin: 5px 0 8px 0; font-size: 12px; color: #856404;">No topups available</p>';
						html += '<a href="<?php echo esc_url( home_url( '/topup/?key=' ) ); ?>' + data.api_key + '" class="button button-primary" style="font-size: 12px; padding: 6px 12px; height: auto; line-height: 1.4;">Buy TopUp Posts</a>';
					} else {
						html += '<p style="margin: 5px 0 0 0; font-size: 12px; color: #856404;">extra posts available</p>';
					}
					
					html += '</div>';
				}
					
					html += '</div>';
						
						// Usage (if available)
						if (typeof data.posts_today !== 'undefined') {
							html += '<div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px; margin-top: 20px; padding-top: 20px; border-top: 1px solid #ddd;">';
							
							// Today's usage - show daily vs extra separately
							html += '<div>';
							html += '<h4 style="margin: 0 0 10px 0; font-size: 14px; color: #666;">Today</h4>';
							html += '<p style="margin: 0; font-size: 16px;"><strong>' + data.posts_today + '</strong> daily / <strong>' + data.posts_per_day + '</strong> limit</p>';
							if (data.extra_posts_today && data.extra_posts_today > 0) {
								html += '<p style="margin: 5px 0 0 0; font-size: 12px; color: #7d3c98;">+ ' + data.extra_posts_today + ' extra post' + (data.extra_posts_today > 1 ? 's' : '') + '</p>';
							}
							html += '<p style="margin: 5px 0 0 0; font-size: 12px; color: #00a32a;">✓ ' + (data.daily_remaining || 0) + ' daily remaining</p>';
							html += '</div>';
							
							// This month's usage - show monthly vs topup breakdown
							if (typeof data.posts_this_month !== 'undefined') {
								var monthlyUsed = data.monthly_used || Math.min(data.posts_this_month, data.posts_per_month);
								var topupsUsed = data.topups_used || Math.max(0, data.posts_this_month - data.posts_per_month);
								
								html += '<div>';
								html += '<h4 style="margin: 0 0 10px 0; font-size: 14px; color: #666;">This Month</h4>';
								html += '<p style="margin: 0; font-size: 16px;"><strong>' + monthlyUsed + '</strong> / <strong>' + (data.posts_per_month || 0) + '</strong> monthly</p>';
								if (topupsUsed > 0) {
									html += '<p style="margin: 5px 0 0 0; font-size: 12px; color: #7d3c98;">+ ' + topupsUsed + ' from topups</p>';
								}
								html += '<p style="margin: 5px 0 0 0; font-size: 12px; color: #00a32a;">✓ ' + (data.monthly_remaining || 0) + ' monthly remaining</p>';
								html += '</div>';
							}
							
				html += '</div>';
			}
			
			// Account info
				if (data.email || data.username) {
					html += '<div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #ddd; font-size: 13px; color: #666;">';
					if (data.email) {
						html += '<p style="margin: 5px 0;"><strong>Email:</strong> ' + data.email + '</p>';
					}
					if (data.username) {
						html += '<p style="margin: 5px 0;"><strong>Username:</strong> ' + data.username + '</p>';
					}
					html += '</div>';
				}
						
						html += '</div>';
						$('#rpm-subscription-details').html(html);
					} else {
						$('#rpm-subscription-details').html(
							'<div class="notice notice-error inline">' +
							'<p>❌ Failed to load subscription information.</p>' +
							'</div>'
						);
					}
				},
				error: function() {
					$('#rpm-subscription-details').html(
						'<div class="notice notice-error inline">' +
						'<p>❌ Error connecting to subscription service. Please check your API key.</p>' +
						'</div>'
					);
				}
			});
		}
		
		// Load on page load
		loadSubscriptionDetails();
		
		// Reload when FastAPI test succeeds
		$(document).on('fastapi-connection-success', function() {
			loadSubscriptionDetails();
		});
	});
	</script>
	
	<hr>
	
	<div style="max-width: 800px;">
	<h2 class="title">🤖 Auto Posting</h2>
	<p>Control automatic daily post creation with AI-generated topics.</p>
	
	<form action="options.php" method="post">
		<?php settings_fields( 'rpm_daily_limit_group' ); ?>
		
		<table class="form-table">
			<tr>
				<th scope="row"><label for="rpm_auto_posting_enabled">Enable Auto Posting</label></th>
				<td>
				<?php $auto_enabled = get_option( 'rpm_auto_posting_enabled', false ); ?>
				<label>
					<input type="checkbox" id="rpm_auto_posting_enabled" name="rpm_auto_posting_enabled" value="1" <?php checked( $auto_enabled, true ); ?> />
					<strong>Automatically create posts via WP-Cron</strong>
				</label>
				<?php 
				if ( function_exists( 'rpm_get_cron_info' ) ) {
					$cron_info = rpm_get_cron_info();
					if ( $cron_info['enabled'] && $cron_info['next_run'] ) {
						echo '<p class="description" style="color: #00a32a; margin-top: 8px;">✅ Next scheduled: <strong>' . esc_html( $cron_info['next_run'] ) . '</strong></p>';
					}
				}
				?>
				</td>
			</tr>
			
			<tr id="rpm_auto_post_hour_row">
				<th scope="row"><label for="rpm_auto_post_hour">Posting Time</label></th>
				<td>
					<?php $post_hour = get_option( 'rpm_auto_post_hour', 9 ); ?>
					<select name="rpm_auto_post_hour" id="rpm_auto_post_hour" style="width: 150px;">
						<?php for ( $h = 0; $h < 24; $h++ ) : 
							$label = sprintf( '%02d:00', $h );
							if ( $h == 0 ) $label .= ' (midnight)';
							elseif ( $h == 12 ) $label .= ' (noon)';
							elseif ( $h < 12 ) $label .= ' AM';
							else $label .= ' PM';
						?>
							<option value="<?php echo $h; ?>" <?php selected( $post_hour, $h ); ?>><?php echo $label; ?></option>
						<?php endfor; ?>
					</select>
					<?php 
					if ( function_exists( 'rpm_get_minute_offset' ) ) {
						$minute = rpm_get_minute_offset();
						echo '<span class="description" style="margin-left: 10px;">+ ' . $minute . ' min offset (unique to your site)</span>';
					}
					?>
					<p class="description">Posts will be created daily at this hour in your WordPress timezone.</p>
				</td>
			</tr>
			
			<tr id="rpm_posts_per_day_row">
				<th scope="row"><label for="rpm_posts_per_day">Posts Per Day</label></th>
				<td>
					<?php 
					// Get subscription limit from API
					$subscription_limit = 1; // Default
					$monthly_limit = 31; // Default
					$fastapi_url = get_option( 'rpm_fastapi_url', '' );
					$fastapi_key = get_option( 'rpm_fastapi_key', '' );
					
					if ( ! empty( $fastapi_url ) && ! empty( $fastapi_key ) ) {
						$response = wp_remote_get(
							rtrim( $fastapi_url, '/' ) . '/me',
							array(
								'headers' => array(
									'Authorization' => 'Bearer ' . $fastapi_key,
									'Content-Type'  => 'application/json',
								),
								'timeout' => 10,
							)
						);
						
						if ( ! is_wp_error( $response ) && wp_remote_retrieve_response_code( $response ) === 200 ) {
							$data = json_decode( wp_remote_retrieve_body( $response ), true );
							if ( isset( $data['user']['limits']['posts_per_day'] ) ) {
								$subscription_limit = (int) $data['user']['limits']['posts_per_day'];
							}
							if ( isset( $data['user']['limits']['posts_per_month'] ) ) {
								$monthly_limit = (int) $data['user']['limits']['posts_per_month'];
							}
						}
					}
					
					// Get current setting, but don't exceed subscription limit
					$current_setting = (int) get_option( 'rpm_posts_per_day', $subscription_limit );
					$posts_per_day = min( $current_setting, $subscription_limit );
					
					// Calculate if daily rate exceeds monthly capacity
					// This will be updated dynamically via JS with actual days remaining
					$days_in_month = 31; // Default, JS will update with actual value
					$monthly_needed = $posts_per_day * $days_in_month;
					$will_run_out = $monthly_needed > $monthly_limit;
					$shortage = $monthly_needed - $monthly_limit;
					?>
					<input type="number" id="rpm_posts_per_day" name="rpm_posts_per_day" value="<?php echo esc_attr( $posts_per_day ); ?>" class="small-text" min="1" max="<?php echo esc_attr( $subscription_limit ); ?>" 
						data-monthly-limit="<?php echo esc_attr( $monthly_limit ); ?>" 
						data-api-key="<?php echo esc_attr( $fastapi_key ); ?>" />
					<p class="description">
						How many posts to create automatically each day.
						<br><strong>Your subscription allows up to <?php echo $subscription_limit; ?> post<?php echo $subscription_limit !== 1 ? 's' : ''; ?> per day.</strong>
					</p>
					<?php if ( $current_setting > $subscription_limit ): ?>
						<p class="description" style="color: #d63638;">
							⚠️ Previous setting (<?php echo $current_setting; ?>) exceeded your subscription limit. Adjusted to <?php echo $subscription_limit; ?>.
						</p>
					<?php endif; ?>
					
					<div id="rpm_monthly_warning" style="display: <?php echo ( $will_run_out && $posts_per_day > 0 ) ? 'block' : 'none'; ?>; margin-top: 12px; padding: 12px 15px; background: #fff3cd; border-left: 4px solid #f0b429; border-radius: 4px;">
						<p style="margin: 0 0 8px 0; color: #856404; font-size: 14px;">
							<strong>⚠️ Monthly Limit Warning</strong>
						</p>
						<p id="rpm_warning_text" style="margin: 0 0 8px 0; color: #856404; font-size: 13px;">
							At <strong><span id="rpm_warning_posts_per_day"><?php echo $posts_per_day; ?></span></strong> post<span id="rpm_warning_plural_1"><?php echo $posts_per_day !== 1 ? 's' : ''; ?></span> per day for the next <strong><span id="rpm_warning_days">31</span> days</strong>, you'll need <strong><span id="rpm_warning_monthly_needed"><?php echo number_format( $monthly_needed ); ?></span> posts</strong>, 
							but your subscription only includes <strong><?php echo number_format( $monthly_limit ); ?> posts/month</strong>.
							<br>You may run out <strong><span id="rpm_warning_shortage"><?php echo number_format( $shortage ); ?></span></strong> post<span id="rpm_warning_plural_2"><?php echo $shortage !== 1 ? 's' : ''; ?></span> short by cycle end.
						</p>
						<p style="margin: 0;">
							<a href="<?php echo home_url( '/topup/?key=' . urlencode( $fastapi_key ) ); ?>" class="button button-primary" style="margin-right: 8px;">
								🛒 Buy TopUp Posts
							</a>
							<span style="font-size: 12px; color: #856404;">TopUp posts never expire and will be used after your monthly allowance.</span>
						</p>
					</div>
					
					<script>
					jQuery(document).ready(function($) {
						var daysRemaining = 31; // Will be updated from API
						
						// Fetch days remaining in billing cycle from API
						$.post(ajaxurl, {
							action: 'findexa_check_subscription',
							nonce: '<?php echo wp_create_nonce( 'findexa_subscription_check' ); ?>'
						}, function(response) {
							if (response.success && response.data) {
								daysRemaining = parseInt(response.data.days_remaining_in_cycle) || 31;
								// Trigger recalculation with new days value
								$('#rpm_posts_per_day').trigger('change');
							}
						});
						
						$('#rpm_posts_per_day').on('input change', function() {
							var postsPerDay = parseInt($(this).val()) || 0;
							var monthlyLimit = parseInt($(this).data('monthly-limit')) || 31;
							var monthlyNeeded = postsPerDay * daysRemaining;
							var shortage = monthlyNeeded - monthlyLimit;
							var willRunOut = monthlyNeeded > monthlyLimit && postsPerDay > 0;
							
							// Update warning visibility
							if (willRunOut) {
								$('#rpm_monthly_warning').fadeIn(200);
							} else {
								$('#rpm_monthly_warning').fadeOut(200);
							}
							
							// Update warning text with days remaining info
							$('#rpm_warning_posts_per_day').text(postsPerDay);
							$('#rpm_warning_monthly_needed').text(monthlyNeeded.toLocaleString());
							$('#rpm_warning_shortage').text(shortage.toLocaleString());
							$('#rpm_warning_days').text(daysRemaining);
							
							// Update pluralization
							$('#rpm_warning_plural_1').text(postsPerDay !== 1 ? 's' : '');
							$('#rpm_warning_plural_2').text(shortage !== 1 ? 's' : '');
						});
					});
					</script>
				</td>
			</tr>
			
			<!-- Queue-related settings hidden - posts now generated on-the-fly -->
			<tr id="rpm_empty_queue_row" style="display: none;">
				<th scope="row"><label>Empty Queue Behavior</label></th>
				<td>
					<?php $empty_behavior = get_option( 'rpm_empty_queue_behavior', 'attempt' ); ?>
					<input type="hidden" name="rpm_empty_queue_behavior" value="attempt" />
				</td>
			</tr>
			
			<tr id="rpm_notify_empty_row" style="display: none;">
				<th scope="row"><label for="rpm_notify_empty_queue">Empty Queue Notifications</label></th>
				<td>
					<?php $notify_empty = get_option( 'rpm_notify_empty_queue', false ); ?>
					<input type="hidden" id="rpm_notify_empty_queue" name="rpm_notify_empty_queue" value="0" />
				</td>
			</tr>
		</table>
		
		<?php submit_button( 'Save Auto Posting Settings' ); ?>
	</form>
	
	<script>
	jQuery(document).ready(function($) {
		// Show/hide auto posting options based on checkbox
	});
	</script>
	</div><!-- End Auto Posting max-width wrapper -->
	<script>
	jQuery(document).ready(function($) {
		$('#rpm_test_fastapi').on('click', function() {
			var $button = $(this);
			var $result = $('#rpm_fastapi_test_result');
			
			$button.prop('disabled', true).text('Testing...');
			$result.html('<p style="color: #666;">⏳ Connecting to FastAPI server...</p>');
			
			var fastapi_url = $('#rpm_fastapi_url').val();
			var fastapi_key = $('#rpm_fastapi_key').val();
			
			if (!fastapi_url || !fastapi_key) {
				$result.html('<p style="color: #d63638;">❌ Please enter both FastAPI URL and API Key first.</p>');
				$button.prop('disabled', false).text('Test FastAPI Connection');
				return;
			}
			
			// Test connection via WordPress AJAX (server-side)
			$.ajax({
				url: ajaxurl,
				type: 'POST',
				data: {
					action: 'rpm_test_fastapi_connection',
					nonce: '<?php echo $rpm_test_nonce; ?>',
					fastapi_url: fastapi_url,
					fastapi_key: fastapi_key
				},
				timeout: 15000,
				success: function(response) {
					if (response.success && response.data) {
						// Simple success message
						$result.html('<div style="padding: 12px; background: #d5f4e6; border-left: 4px solid #00a32a; border-radius: 4px;"><p style="margin: 0; color: #00a32a;"><strong>✅ Connection Successful!</strong></p></div>');
						
						// Trigger event to reload subscription details
						$(document).trigger('fastapi-connection-success');
					} else {
						var errorMsg = response.data && response.data.message ? response.data.message : 'Unexpected response';
						$result.html('<div style="padding: 12px; background: #f8d7da; border-left: 4px solid #d63638; border-radius: 4px;"><p style="margin: 0; color: #721c24;"><strong>❌ ' + errorMsg + '</strong></p></div>');
					}
					$button.prop('disabled', false).text('Test FastAPI Connection');
				},
				error: function(xhr, status, error) {
					// Simple failure message
					$result.html('<div style="padding: 12px; background: #f8d7da; border-left: 4px solid #d63638; border-radius: 4px;"><p style="margin: 0; color: #721c24;"><strong>❌ Connection Failed</strong></p></div>');
					$button.prop('disabled', false).text('Test FastAPI Connection');
				}
			});
		});
	});
	</script>
	
	<!-- Post Limit Status - Now tracked in FastAPI -->
	<div id="rpm-post-limit-status" style="margin-top: 20px; display: none;">
		<!-- Disabled: Old external API call. Post limits now tracked in FastAPI. -->
	</div>
	
	<script>
	jQuery(document).ready(function($) {
		// Post limit info is now fetched from FastAPI when you test the connection
		function fetchPostLimitInfo() {
			// Disabled - this was calling an old external API
			return;
			
			$.ajax({
				url: 'https://findexa.ca/api/post-limit-info.php',
				type: 'GET',
				dataType: 'json',
				data: {
					api_key: '<?php echo $rpm_api_key; ?>'
				},
				timeout: 10000, // 10 seconds
				success: function(response) {
					if (response.success) {
						var html = '';
						
						if (response.has_limit) {
							var percentage = response.monthly_limit > 0 ? (response.posts_used / response.monthly_limit) * 100 : 0;
							var statusColor = '#00a32a'; // green
							var statusIcon = '✅';
							
							if (percentage >= 90) {
								statusColor = '#d63638'; // red
								statusIcon = '⚠️';
							} else if (percentage >= 70) {
								statusColor = '#dba617'; // yellow/orange
								statusIcon = '⚠️';
							}
							
							html += '<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 15px;">';
							
							// Monthly Limit
							html += '<div style="background: #fff; padding: 15px; border-radius: 4px; border: 2px solid #e0e0e0;">';
							html += '<div style="color: #666; font-size: 12px; text-transform: uppercase; margin-bottom: 5px;">Monthly Limit</div>';
							html += '<div style="font-size: 28px; font-weight: bold; color: #2271b1;">' + response.monthly_limit + '</div>';
							html += '<div style="color: #666; font-size: 13px; margin-top: 5px;">posts allowed</div>';
							html += '</div>';
							
							// Posts Used
							html += '<div style="background: #fff; padding: 15px; border-radius: 4px; border: 2px solid #e0e0e0;">';
							html += '<div style="color: #666; font-size: 12px; text-transform: uppercase; margin-bottom: 5px;">Used This Month</div>';
							html += '<div style="font-size: 28px; font-weight: bold; color: ' + statusColor + ';">' + response.posts_used + '</div>';
							html += '<div style="color: #666; font-size: 13px; margin-top: 5px;">posts created</div>';
							html += '</div>';
							
							// Remaining
							html += '<div style="background: #fff; padding: 15px; border-radius: 4px; border: 2px solid #e0e0e0;">';
							html += '<div style="color: #666; font-size: 12px; text-transform: uppercase; margin-bottom: 5px;">Remaining</div>';
							html += '<div style="font-size: 28px; font-weight: bold; color: ' + statusColor + ';">' + response.remaining + '</div>';
							html += '<div style="color: #666; font-size: 13px; margin-top: 5px;">posts left</div>';
							html += '</div>';
							
							html += '</div>';
							
							// Progress Bar
							html += '<div style="margin-bottom: 10px;">';
							html += '<div style="background: #ddd; height: 24px; border-radius: 12px; overflow: hidden; box-shadow: inset 0 1px 3px rgba(0,0,0,0.1);">';
							html += '<div style="background: ' + statusColor + '; height: 100%; width: ' + percentage.toFixed(1) + '%; transition: width 0.3s; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 12px;">';
							if (percentage > 10) { // Only show text if bar is wide enough
								html += percentage.toFixed(1) + '%';
							}
							html += '</div>';
							html += '</div>';
							html += '</div>';
							
							// Status Message
							var statusMsg = '';
							if (response.remaining <= 0) {
								statusMsg = '<div style="padding: 10px; background: #f8d7da; border-left: 4px solid #d63638; border-radius: 3px; color: #721c24;">';
								statusMsg += '<strong>' + statusIcon + ' Monthly limit reached!</strong> No more posts can be created this month. The limit will reset on ' + response.next_reset + '.';
								statusMsg += '</div>';
							} else if (percentage >= 90) {
								statusMsg = '<div style="padding: 10px; background: #fcf8e3; border-left: 4px solid #dba617; border-radius: 3px; color: #856404;">';
								statusMsg += '<strong>' + statusIcon + ' Almost at limit!</strong> Only ' + response.remaining + ' post(s) remaining this month.';
								statusMsg += '</div>';
							} else {
								statusMsg = '<div style="padding: 10px; background: #d5f4e6; border-left: 4px solid #00a32a; border-radius: 3px; color: #00401c;">';
								statusMsg += '<strong>' + statusIcon + ' Looking good!</strong> ' + response.remaining + ' post(s) remaining out of ' + response.monthly_limit + ' this month.';
								statusMsg += '</div>';
							}
							html += statusMsg;
							
							// Last Reset Info
							if (response.last_reset) {
								html += '<div style="margin-top: 15px; padding-top: 15px; border-top: 1px solid #ddd; color: #666; font-size: 13px;">';
								html += '<strong>API Key:</strong> ' + response.api_key_name + '<br>';
								html += '<strong>Last Reset:</strong> ' + response.last_reset + '<br>';
								html += '<strong>Next Reset:</strong> ' + response.next_reset;
								html += '</div>';
							}
						} else {
							// Unlimited posts
							html += '<div style="text-align: center; padding: 30px;">';
							html += '<div style="font-size: 48px; margin-bottom: 10px;">∞</div>';
							html += '<div style="font-size: 20px; font-weight: bold; color: #2271b1; margin-bottom: 5px;">Unlimited Posts</div>';
							html += '<div style="color: #666;">No monthly limit configured for API key: <strong>' + response.api_key_name + '</strong></div>';
							html += '</div>';
						}
						
						$('#rpm-post-limit-content').html(html);
					} else {
						$('#rpm-post-limit-content').html(
							'<div style="padding: 10px; background: #f8d7da; border-left: 4px solid #d63638; border-radius: 3px;">' +
							'<strong>❌ Error:</strong> ' + (response.message || 'Failed to fetch post limit information') +
							'</div>'
						);
					}
				},
				error: function(xhr, status, error) {
					var errorMsg = 'Failed to connect to API server';
					
					if (status === 'timeout') {
						errorMsg = 'Request timeout - API server not responding';
					} else if (xhr.status === 404) {
						errorMsg = 'API endpoint not found (404)';
					} else if (xhr.status === 403) {
						errorMsg = 'API authentication failed (403)';
					}
					
					$('#rpm-post-limit-content').html(
						'<div style="padding: 10px; background: #f8d7da; border-left: 4px solid #d63638; border-radius: 3px;">' +
						'<strong>❌ Connection Error:</strong> ' + errorMsg +
						'<br><small style="color: #666; margin-top: 5px; display: block;">Make sure the API server at <code>https://findexa.ca/api</code> is running and accessible.</small>' +
						'</div>'
					);
				}
			});
		}
		
		// Fetch on page load
		fetchPostLimitInfo();
		
		// Add refresh button functionality
		$(document).on('click', '#rpm-refresh-post-limit', function() {
			$(this).prop('disabled', true).text('Refreshing...');
			$('#rpm-post-limit-content').html(
				'<p style="margin: 0; text-align: center;">' +
				'<span class="spinner is-active" style="float: none; margin: 0 10px 0 0;"></span>' +
				'Refreshing post limit information...' +
				'</p>'
			);
			fetchPostLimitInfo();
		});
	});
	</script>
<script>
// ============================================================================
// SETUP CODE VERIFICATION
// ============================================================================
jQuery(document).ready(function($) {
	// Auto-format code input
	$("#rpm_setup_code").on("input", function() {
		var val = $(this).val().replace(/[^0-9]/g, "");
		if (val.length > 6) val = val.substring(0, 6);
		$(this).val(val);
		
		if (val.length === 6) {
			$("#code-status").text("✓ Code format valid").css("color", "#00a32a");
		} else if (val.length > 0) {
			$("#code-status").text("Enter 6 digits").css("color", "#666");
		} else {
			$("#code-status").text("");
		}
	});
	
	// Verify code button click
	$("#rpm_verify_code").on("click", function() {
		var code = $("#rpm_setup_code").val();
		var $button = $(this);
		var $result = $("#code-result");
		var fastapi_url = $("#rpm_fastapi_url").val() || "https://findexa.ca";
		
		if (code.length !== 6) {
			$result.html("<div style=\"padding: 10px; background: #f8d7da; border-left: 4px solid #d63638; color: #d63638; border-radius: 4px;\">Please enter a 6-digit code</div>");
			return;
		}
		
		$button.prop("disabled", true).text("Verifying...");
		$("#code-status").text("Checking code...").css("color", "#666");
		
		// Call WordPress AJAX to verify code (server-side)
		$.ajax({
			url: ajaxurl,
			method: "POST",
			data: {
				action: "rpm_verify_setup_code",
				nonce: "<?php echo wp_create_nonce('rpm_verify_setup_code'); ?>",
				code: code,
				fastapi_url: fastapi_url
			},
			success: function(response) {
				if (response.success && response.data) {
					var data = response.data;
					// Success! Auto-fill the settings
					$("#rpm_fastapi_url").val(data.server_url);
					$("#rpm_fastapi_key").val(data.api_key);
					
					$result.html(
						"<div style=\"padding: 15px; background: #d5f4e6; border-left: 4px solid #00a32a; color: #00a32a; border-radius: 4px;\">" +
						"<strong>✅ Success!</strong><br>" +
						"Server URL and API Key have been automatically configured!<br>" +
						"Plan: <strong>" + data.subscription_plan.toUpperCase() + "</strong><br>" +
						"Email: <strong>" + data.email + "</strong><br><br>" +
						"<strong>Don't forget to save your settings below!</strong>" +
						"</div>"
					);
					
					// Scroll to save button
					$("html, body").animate({
						scrollTop: $("input[name=\"submit\"]").offset().top - 100
					}, 500);
				} else {
					$result.html(
						"<div style=\"padding: 15px; background: #f8d7da; border-left: 4px solid #d63638; color: #d63638; border-radius: 4px;\">" +
						"<strong>❌ Error:</strong> " + (response.data && response.data.message ? response.data.message : "Failed to verify code") + "<br>" +
						"<small>Code may be expired (5 min limit) or already used.</small>" +
						"</div>"
					);
					$("#code-status").text("✗ Invalid or expired").css("color", "#d63638");
				}
			},
			error: function(xhr) {
				var errorMsg = "Failed to verify code";
				if (xhr.responseJSON && xhr.responseJSON.data && xhr.responseJSON.data.message) {
					errorMsg = xhr.responseJSON.data.message;
				}
				
				$result.html(
					"<div style=\"padding: 15px; background: #f8d7da; border-left: 4px solid #d63638; color: #d63638; border-radius: 4px;\">" +
					"<strong>❌ Error:</strong> " + errorMsg + "<br>" +
					"<small>Code may be expired (5 min limit) or already used.</small>" +
					"</div>"
				);
				
				$("#code-status").text("✗ Invalid or expired").css("color", "#d63638");
			},
			complete: function() {
				$button.prop("disabled", false).text("✓ Verify");
			}
		});
	});
	
	// Allow Enter key to submit
	$("#rpm_setup_code").on("keypress", function(e) {
		if (e.which === 13) {
			$("#rpm_verify_code").click();
		}
	});
});
</script>
	

	<hr>
	
	<div style="max-width: 800px;">
	<h2 class="title">📅 Daily Auto-Post Trigger</h2>
	<p>Send posts based on your daily subscription limit, with optional extra posts from your monthly allowance.</p>
	
	<?php
	// Get monthly usage info and topups from API for extra posts calculation
	$monthly_remaining = 0;
	$monthly_limit = 0;
	$monthly_used = 0;
	$topup_posts = 0;
	$total_available = 0;
	$fastapi_url = get_option( 'rpm_fastapi_url', '' );
	$fastapi_key = get_option( 'rpm_fastapi_key', '' );
	
	if ( ! empty( $fastapi_url ) && ! empty( $fastapi_key ) ) {
		$response = wp_remote_get(
			rtrim( $fastapi_url, '/' ) . '/me',
			array(
				'headers' => array(
					'Authorization' => 'Bearer ' . $fastapi_key,
					'Content-Type'  => 'application/json',
				),
				'timeout' => 10,
			)
		);
		
		if ( ! is_wp_error( $response ) && wp_remote_retrieve_response_code( $response ) === 200 ) {
			$data = json_decode( wp_remote_retrieve_body( $response ), true );
			if ( isset( $data['user']['usage'] ) ) {
				$monthly_remaining = (int) ( $data['user']['usage']['monthly_remaining'] ?? 0 );
				$monthly_limit = (int) ( $data['user']['limits']['posts_per_month'] ?? 0 );
				$monthly_used = (int) ( $data['user']['usage']['posts_this_month'] ?? 0 );
				$topup_posts = (int) ( $data['user']['limits']['topup_posts'] ?? 0 );
				$total_available = (int) ( $data['user']['usage']['total_available'] ?? $monthly_remaining );
			}
		}
	}
	?>
	
	<div style="background: #fff; border: 1px solid #c3c4c7; border-radius: 4px; padding: 20px; margin-bottom: 20px;">
		<!-- Daily limits info (loaded dynamically) -->
		<div id="daily-trigger-info" style="margin-bottom: 15px;">
			<p><strong>Loading daily post information...</strong></p>
		</div>
		
		<!-- Extra posts checkbox -->
		<div id="extra-posts-section" style="margin-bottom: 15px; padding: 15px; background: #f6f7f7; border-radius: 4px;">
			<label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
				<input type="checkbox" id="send-extra-posts-checkbox" />
				<span style="font-weight: 600;">Send extra posts</span>
			</label>
			<div id="extra-posts-input-section" style="display: none; margin-top: 10px; padding-left: 25px;">
				<div style="display: flex; align-items: center; gap: 10px;">
					<label for="extra-posts-count">Number of extra posts:</label>
					<input type="number" id="extra-posts-count" value="1" min="1" max="<?php echo esc_attr( $total_available ); ?>" style="width: 80px;" />
				</div>
				<p class="description" id="extra-posts-breakdown" style="margin-top: 5px; color: #666;">
					Extra posts available: <strong id="extra-posts-available"><?php echo number_format_i18n( $total_available ); ?></strong> 
					(<span id="extra-monthly-count"><?php echo number_format_i18n( $monthly_remaining ); ?></span> monthly + <span id="extra-topup-count"><?php echo number_format_i18n( $topup_posts ); ?></span> topups)
				</p>
				<p class="description" style="margin-top: 3px; color: #666; font-style: italic;">
					Extra posts only deduct from monthly/topups, not from your daily limit.
				</p>
				<!-- Dynamic warning will be inserted here -->
			</div>
		</div>
		
		<button type="button" id="run-daily-posts-btn" class="button button-primary button-large" disabled>
			<span class="dashicons dashicons-controls-play" style="margin-top: 3px;"></span>
			<span id="btn-text">Run Today's Posts Now</span>
		</button>
		
		<!-- Progress bar and status -->
		<div id="rpm_batch_status" style="margin-top: 15px;"></div>
	</div>
	
</div>
</div><!-- End Daily Auto-Post Trigger max-width wrapper -->

<script>
jQuery(document).ready(function($) {
	// Global generation state
	var generationState = {
		total: 0,
		current: 0,
		created: 0,
		failed: 0,
		errors: [],
		isGenerating: false,
		dailyCount: 0,
		extraCount: 0
	};
	
	// Progress animation variables
	var progressInterval = null;
	var smoothProgress = 0;
	
	// Daily info variables
	var dailyPostsToSend = 0;
	var dailyAlreadySent = 0;
	var dailyLimit = 0;
	var monthlyRemaining = <?php echo (int) $monthly_remaining; ?>;
	var topupPosts = <?php echo (int) $topup_posts; ?>;
	var totalAvailable = <?php echo (int) $total_available; ?>;
	var apiKey = '<?php echo esc_js( get_option( 'rpm_fastapi_key', '' ) ); ?>';
	var topupUrl = '<?php echo esc_url( home_url( '/topup/' ) ); ?>?key=' + apiKey;
	
	// Toggle extra posts input visibility
	$('#send-extra-posts-checkbox').on('change', function() {
		if ($(this).is(':checked')) {
			$('#extra-posts-input-section').slideDown(200);
			updateExtraPostsWarning();
		} else {
			$('#extra-posts-input-section').slideUp(200);
			$('#extra-posts-warning').remove();
		}
		updateButtonText();
	});
	
	$('#extra-posts-count').on('input', function() {
		updateButtonText();
		updateExtraPostsWarning();
	});
	
	// Show warning/TopUp message based on extra posts availability
	function updateExtraPostsWarning() {
		$('#extra-posts-warning').remove();
		
		var requestedExtra = parseInt($('#extra-posts-count').val()) || 0;
		var warningHtml = '';
		
		if (totalAvailable <= 0) {
			// No credits available at all
			warningHtml = '<div id="extra-posts-warning" style="margin-top: 10px; padding: 12px; background: #fef3f2; border: 1px solid #f87171; border-radius: 4px;">' +
				'<p style="margin: 0 0 10px 0; color: #b91c1c;"><strong>⚠️ No extra posts available!</strong></p>' +
				'<p style="margin: 0 0 10px 0; color: #666;">Your monthly allowance is depleted and you have no TopUp credits.</p>' +
				'<a href="' + topupUrl + '" class="button button-primary" style="background: #7c3aed; border-color: #7c3aed;">🛒 Buy TopUp Posts</a>' +
			'</div>';
		} else if (requestedExtra > totalAvailable) {
			// Requested more than available
			warningHtml = '<div id="extra-posts-warning" style="margin-top: 10px; padding: 12px; background: #fffbeb; border: 1px solid #f59e0b; border-radius: 4px;">' +
				'<p style="margin: 0 0 10px 0; color: #92400e;"><strong>⚠️ Only ' + totalAvailable + ' extra post' + (totalAvailable !== 1 ? 's' : '') + ' available</strong></p>' +
				'<p style="margin: 0 0 10px 0; color: #666;">You requested ' + requestedExtra + ' but only have ' + totalAvailable + ' (' + monthlyRemaining + ' monthly + ' + topupPosts + ' topups).</p>' +
				'<div style="display: flex; gap: 10px; flex-wrap: wrap;">' +
					'<button type="button" class="button" onclick="$(\'#extra-posts-count\').val(' + totalAvailable + ').trigger(\'input\');">✓ Use ' + totalAvailable + ' available</button>' +
					'<a href="' + topupUrl + '" class="button" style="background: #7c3aed; border-color: #7c3aed; color: #fff;">🛒 Get More TopUps</a>' +
				'</div>' +
			'</div>';
		}
		
		if (warningHtml) {
			$('#extra-posts-input-section').append(warningHtml);
		}
	}
	
	// Update button text based on selections
	function updateButtonText() {
		var extraCount = $('#send-extra-posts-checkbox').is(':checked') ? parseInt($('#extra-posts-count').val()) || 0 : 0;
		var totalText = dailyPostsToSend + extraCount;
		
		if (totalText > 0) {
			$('#btn-text').text('Send ' + totalText + ' Post' + (totalText > 1 ? 's' : '') + ' Now');
		} else {
			$('#btn-text').text('Run Today\'s Posts Now');
		}
	}
	
	// Function to generate a single post ON-THE-FLY (NO QUEUE)
	function generateSinglePost(callback, isDailyAutoPost) {
		isDailyAutoPost = isDailyAutoPost || false;
		
		$.ajax({
			url: ajaxurl,
			type: 'POST',
			data: {
				action: 'rpm_generate_post_on_the_fly',
				nonce: '<?php echo wp_create_nonce('rpm_on_the_fly'); ?>',
				is_daily_auto_post: isDailyAutoPost ? 'true' : 'false'
			},
			timeout: 60000,
			success: function(response) {
				if (response.success) {
					callback(true, response.data);
				} else {
					var errorMsg = response.data && response.data.message ? response.data.message : 'Unknown error';
					generationState.errors.push(errorMsg);
					callback(false, response.data);
				}
			},
			error: function(xhr, status, error) {
				var errorMsg = 'Network error';
				if (status === 'timeout') {
					errorMsg = 'Timeout (post took too long)';
				} else if (xhr.responseJSON && xhr.responseJSON.data && xhr.responseJSON.data.message) {
					errorMsg = xhr.responseJSON.data.message;
				}
				generationState.errors.push(errorMsg);
				callback(false, { error: errorMsg });
			}
		});
	}
	
	// Update progress display
	function updateProgress(postTitle, forceUpdate) {
		var $status = $('#rpm_batch_status');
		
		if (forceUpdate || $status.find('.rpm-progress-fill').length === 0) {
			var html = '<div style="padding: 15px; background: #f0f6fc; border-left: 4px solid #2271b1; border-radius: 4px;">';
			html += '<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">';
			html += '<strong>🚀 Generating Posts</strong>';
			html += '<span id="rpm-progress-counter" style="font-weight: 600; color: #2271b1;">' + generationState.current + ' / ' + generationState.total + '</span>';
			html += '</div>';
			
			html += '<div style="background: #ddd; height: 24px; border-radius: 12px; overflow: hidden; margin-bottom: 10px;">';
			html += '<div class="rpm-progress-fill" style="background: linear-gradient(90deg, #2271b1, #135e96); height: 100%; width: 0%; transition: width 0.3s ease-out; display: flex; align-items: center; justify-content: center; color: white; font-size: 11px; font-weight: 600;">';
			html += '<span id="rpm-progress-percent"></span>';
			html += '</div></div>';
			
			html += '<p id="rpm-current-post" style="margin: 5px 0; color: #666; font-size: 13px;">📝 Initializing...</p>';
			html += '<div style="display: flex; gap: 20px; font-size: 13px;">';
			html += '<span id="rpm-stat-created" style="color: #00a32a;">✅ Created: 0</span>';
			html += '<span id="rpm-stat-failed" style="color: #d63638;">❌ Failed: 0</span>';
			html += '</div></div>';
			
			$status.html(html);
			smoothProgress = 0;
		}
		
		$('#rpm-progress-counter').text(generationState.current + ' / ' + generationState.total);
		if (postTitle) {
			$('#rpm-current-post').text('📝 ' + postTitle);
		}
		$('#rpm-stat-created').text('✅ Created: ' + generationState.created);
		$('#rpm-stat-failed').text('❌ Failed: ' + generationState.failed);
	}
	
	// Show completion message
	function showCompletion() {
		var $status = $('#rpm_batch_status');
		var $button = $('#run-daily-posts-btn');
		
		if (progressInterval) {
			clearInterval(progressInterval);
			progressInterval = null;
		}
		
		$('.rpm-progress-fill').css('width', '100%');
		$('#rpm-progress-percent').text('100%');
		
		setTimeout(function() {
			var html = '<div style="padding: 15px; background: #d5f4e6; border-left: 4px solid #00a32a; border-radius: 4px;">';
			html += '<strong style="color: #00a32a;">✅ Generation Complete!</strong><br>';
			html += '<div style="margin: 10px 0;">';
			html += '<span style="color: #00a32a; font-weight: 600;">✅ Created: ' + generationState.created + ' post(s)</span>';
			if (generationState.failed > 0) {
				html += '<br><span style="color: #d63638; font-weight: 600;">❌ Failed: ' + generationState.failed + ' post(s)</span>';
			}
			html += '</div>';
			
			if (generationState.errors.length > 0) {
				html += '<details style="margin-top: 10px; padding: 10px; background: #fff; border: 1px solid #ddd; border-radius: 4px;">';
				html += '<summary style="cursor: pointer; font-weight: 600; color: #d63638;">View Errors</summary>';
				html += '<ul style="margin: 10px 0 0 20px; font-size: 12px;">';
				generationState.errors.forEach(function(err) {
					html += '<li style="color: #666; margin: 5px 0;">' + err + '</li>';
				});
				html += '</ul></details>';
			}
			
			html += '<a href="edit.php" class="button button-primary" style="margin-top: 10px;">View Posts</a>';
			html += '</div>';
			
			$status.html(html);
			$button.prop('disabled', false);
			$('#btn-text').text('Run Today\'s Posts Now');
			generationState.isGenerating = false;
			
			setTimeout(function() { location.reload(); }, 3000);
		}, 500);
	}
	
	// Smooth progress animation
	function startSmoothProgressAnimation(postNumber, estimatedDuration) {
		if (progressInterval) clearInterval(progressInterval);
		
		var startProgress = ((postNumber - 1) / generationState.total) * 100;
		var endProgress = (postNumber / generationState.total) * 100;
		var progressRange = endProgress - startProgress;
		
		var updateFrequency = 100;
		var totalSteps = estimatedDuration / updateFrequency;
		var progressPerStep = progressRange / totalSteps;
		var currentStep = 0;
		
		smoothProgress = startProgress;
		
		progressInterval = setInterval(function() {
			currentStep++;
			var easingFactor = Math.max(0.2, 1 - (currentStep / totalSteps));
			smoothProgress += progressPerStep * easingFactor;
			
			var maxProgress = startProgress + (progressRange * 0.8);
			if (smoothProgress > maxProgress) smoothProgress = maxProgress;
			
			$('.rpm-progress-fill').css('width', smoothProgress + '%');
			if (smoothProgress > 10) {
				$('#rpm-progress-percent').text(Math.round(smoothProgress) + '%');
			}
			
			if (currentStep >= totalSteps * 0.9) clearInterval(progressInterval);
		}, updateFrequency);
	}
	
	// Main generation function - handles both daily and extra posts
	function startGeneration(dailyCount, extraCount) {
		var totalCount = dailyCount + extraCount;
		
		generationState = {
			total: totalCount,
			current: 0,
			created: 0,
			failed: 0,
			errors: [],
			isGenerating: true,
			dailyCount: dailyCount,
			extraCount: extraCount
		};
		
		updateProgress('Initializing...', true);
		
		function processNext() {
			if (generationState.current >= generationState.total) {
				if (progressInterval) clearInterval(progressInterval);
				showCompletion();
				return;
			}
			
			generationState.current++;
			
			// Determine if this is a daily post or extra post
			var isDailyPost = generationState.current <= generationState.dailyCount;
			var phaseLabel = isDailyPost ? '(daily)' : '(extra)';
			
			startSmoothProgressAnimation(generationState.current, 40000);
			updateProgress('Generating post ' + generationState.current + ' of ' + generationState.total + ' ' + phaseLabel + '...', false);
			
			// is_daily_auto_post: true for daily posts (checks daily limit)
			// is_daily_auto_post: false for extra posts (only checks monthly+topups)
			generateSinglePost(function(success, data) {
				if (progressInterval) clearInterval(progressInterval);
				
				if (success) {
					generationState.created++;
					if (data.post_title) {
						updateProgress('✅ ' + data.post_title, false);
					}
				} else {
					generationState.failed++;
					updateProgress('❌ Failed to generate post', false);
				}
				
				setTimeout(processNext, 500);
			}, isDailyPost);
		}
		
		processNext();
	}
	
	// Fetch daily info from API
	function loadDailyInfo() {
		$.post(ajaxurl, {
			action: 'findexa_check_subscription',
			nonce: '<?php echo wp_create_nonce( 'findexa_subscription_check' ); ?>'
		}, function(response) {
			if (response.success && response.data) {
				dailyLimit = parseInt(response.data.posts_per_day) || 0;
				dailyAlreadySent = parseInt(response.data.posts_today) || 0;  // Daily posts only
				var extraSentToday = parseInt(response.data.extra_posts_today) || 0;  // Extra posts
				dailyPostsToSend = Math.max(0, dailyLimit - dailyAlreadySent);
				
				// Update availability from API response
				monthlyRemaining = parseInt(response.data.monthly_remaining) || 0;
				topupPosts = parseInt(response.data.topup_posts) || 0;
				totalAvailable = parseInt(response.data.total_available) || (monthlyRemaining + topupPosts);
				
				// Update the extra posts display
				$('#extra-posts-available').text(totalAvailable);
				$('#extra-monthly-count').text(monthlyRemaining);
				$('#extra-topup-count').text(topupPosts);
				$('#extra-posts-count').attr('max', totalAvailable);
				
				// Refresh warning if checkbox is already checked
				if ($('#send-extra-posts-checkbox').is(':checked')) {
					updateExtraPostsWarning();
				}
				
				// Show 4 columns if extra posts exist, otherwise 3
				var hasExtra = extraSentToday > 0;
				var gridCols = hasExtra ? '4' : '3';
				
				var html = '<div style="display: grid; grid-template-columns: repeat(' + gridCols + ', 1fr); gap: 15px; margin-bottom: 15px;">';
				
				html += '<div style="background: #f0f6fc; padding: 15px; border-radius: 4px; text-align: center;">';
				html += '<div style="font-size: 24px; font-weight: 700; color: #2271b1;">' + dailyLimit + '</div>';
				html += '<div style="font-size: 12px; color: #666;">Daily Limit</div>';
				html += '</div>';
				
				html += '<div style="background: #fff3cd; padding: 15px; border-radius: 4px; text-align: center;">';
				html += '<div style="font-size: 24px; font-weight: 700; color: #856404;">' + dailyAlreadySent + '</div>';
				html += '<div style="font-size: 12px; color: #666;">Daily Sent</div>';
				html += '</div>';
				
				html += '<div style="background: #d5f4e6; padding: 15px; border-radius: 4px; text-align: center;">';
				html += '<div style="font-size: 24px; font-weight: 700; color: #00a32a;">' + dailyPostsToSend + '</div>';
				html += '<div style="font-size: 12px; color: #666;">Remaining</div>';
				html += '</div>';
				
				// Show extra posts if any were sent today
				if (hasExtra) {
					html += '<div style="background: #e8daef; padding: 15px; border-radius: 4px; text-align: center;">';
					html += '<div style="font-size: 24px; font-weight: 700; color: #7d3c98;">' + extraSentToday + '</div>';
					html += '<div style="font-size: 12px; color: #666;">Extra Sent</div>';
					html += '</div>';
				}
				
				html += '</div>';
				
				if (dailyPostsToSend > 0) {
					html += '<p style="padding: 10px; background: #d5eaff; border-left: 4px solid #2271b1; margin: 0 0 5px 0;">📅 Ready to send <strong>' + dailyPostsToSend + ' daily post' + (dailyPostsToSend > 1 ? 's' : '') + '</strong></p>';
					$('#run-daily-posts-btn').prop('disabled', false);
				} else {
					html += '<p style="padding: 10px; background: #fcf3cf; border-left: 4px solid #f39c12; margin: 0 0 5px 0;">⚠️ Daily limit reached for today. Click "Send extra posts" to override.</p>';
					// Button can still be enabled for extra posts
					$('#run-daily-posts-btn').prop('disabled', totalAvailable <= 0);
				}
				
				$('#daily-trigger-info').html(html);
				updateButtonText();
			} else {
				$('#daily-trigger-info').html('<p style="color: #d63638;"><strong>⚠️ Error:</strong> Unable to load daily post information.</p>');
			}
		}).fail(function() {
			$('#daily-trigger-info').html('<p style="color: #d63638;"><strong>⚠️ Error:</strong> Failed to connect to server.</p>');
		});
	}
	
	loadDailyInfo();
	
	// Main button click handler
	$('#run-daily-posts-btn').click(function() {
		if (generationState.isGenerating) {
			alert('Generation already in progress');
			return;
		}
		
		var extraChecked = $('#send-extra-posts-checkbox').is(':checked');
		var extraCount = extraChecked ? parseInt($('#extra-posts-count').val()) || 0 : 0;
		var totalToSend = dailyPostsToSend + extraCount;
		
		if (totalToSend <= 0) {
			alert('No posts to send. Check your daily remaining or enable extra posts.');
			return;
		}
		
		// Validate extra posts against available
		if (extraCount > totalAvailable) {
			extraCount = totalAvailable;
		}
		
		// Build confirmation message
		var confirmMsg = 'Send ' + totalToSend + ' post' + (totalToSend > 1 ? 's' : '') + '?\n\n';
		if (dailyPostsToSend > 0) {
			confirmMsg += '• ' + dailyPostsToSend + ' daily post' + (dailyPostsToSend > 1 ? 's' : '') + ' (counts towards daily limit)\n';
		}
		if (extraCount > 0) {
			confirmMsg += '• ' + extraCount + ' extra post' + (extraCount > 1 ? 's' : '') + ' (deducts from monthly/topups only)\n';
		}
		
		if (!confirm(confirmMsg)) {
			return;
		}
		
		var $button = $(this);
		$button.prop('disabled', true);
		$('#btn-text').text('⏳ Generating...');
		
		startGeneration(dailyPostsToSend, extraCount);
	});
});
</script>

