<?php
if ( ! defined( 'ABSPATH' ) ) exit;

if ( isset( $_GET['settings-updated'] ) ) {
	add_settings_error( 'rpm_messages', 'rpm_message', 'Settings saved successfully.', 'updated' );
}
settings_errors( 'rpm_messages' );
?>
<div class="wrap" style="max-width: 800px;">
	<h1 class="wp-heading-inline">
		<span class="dashicons dashicons-admin-settings" style="font-size: 28px; width: 28px; height: 28px; vertical-align: middle;"></span>
		Content Settings
	</h1>
	<p class="description" style="margin-top: 10px; font-size: 14px;">Configure how AI generates content including site analysis, topic preferences, and content style.</p>
	
	<hr class="wp-header-end">
	
	
	<hr>
	
	<!-- SECTION 2: CONFIGURE SETTINGS INTRO -->
	<h2 class="title">⚙️ Content Settings</h2>
	<p>These settings control how the AI generates content for your posts.</p>
	
	<!-- SECTION 3: UNDERSTANDING YOUR SETTINGS -->
	<div class="rpm-info-footer">
		<h2>📚 Understanding Your Settings</h2>
		<p style="margin-bottom: 20px;">The AI uses these settings to generate content that matches your brand voice, audience, and goals. The more specific you are, the better the content will align with your needs.</p>
		<div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px;">
			<div style="background: #f0f6fc; padding: 15px; border-left: 3px solid #2271b1; border-radius: 4px;">
				<h3 style="margin-top: 0;">🎯 Site & Audience</h3>
				<p style="margin: 0;">Define WHO you are and WHO you serve. These are the foundation - AI uses them for every piece of content.</p>
			</div>
			<div style="background: #f0f6fc; padding: 15px; border-left: 3px solid #2271b1; border-radius: 4px;">
				<h3 style="margin-top: 0;">✍️ Style & Tone</h3>
				<p style="margin: 0;">Control HOW the AI writes. Choose the personality and structure that matches your brand voice.</p>
			</div>
			<div style="background: #f0f6fc; padding: 15px; border-left: 3px solid #2271b1; border-radius: 4px;">
				<h3 style="margin-top: 0;">⚙️ Configuration</h3>
				<p style="margin: 0;">Fine-tune content length, SEO keywords, and post publishing behavior.</p>
			</div>
			<div style="background: #f0f6fc; padding: 15px; border-left: 3px solid #2271b1; border-radius: 4px;">
				<h3 style="margin-top: 0;">📋 Content Snapshots</h3>
				<p style="margin: 0;">Each queued post saves its settings at creation time, allowing you to experiment with different configurations.</p>
			</div>
		</div>
		<div style="margin-top: 15px; padding: 12px; background: #e7f5ff; border-left: 3px solid #0073aa; border-radius: 4px;">
			<strong>How AI Uses These Settings:</strong>
			<ul style="margin: 10px 0 0 20px;">
				<li><strong>Post Generation:</strong> AI creates post ideas based on your industry and target audience</li>
				<li><strong>Content Creation:</strong> AI writes posts matching your tone, style, and expertise level</li>
				<li><strong>SEO Optimization:</strong> Keywords are naturally incorporated with proper priority</li>
			</ul>
		</div>
	</div>
	
	<hr>
	
	<!-- SECTION 4: ACTUAL SETTINGS FORM -->
	<form action="options.php" method="post">
		<?php settings_fields( 'rpm_ai_content_group' ); ?>
		
		<h2 class="title">Site Information</h2>
		
		<div style="background: #fff; border: 1px solid #c3c4c7; border-radius: 4px; padding: 20px; margin-bottom: 20px;">
			<div style="background: #e7f5ff; padding: 15px; border-left: 3px solid #0073aa; border-radius: 4px; margin-bottom: 15px;">
				<h3 style="margin-top: 0; font-size: 14px;">🤖 AI-Powered Form Filler</h3>
				<p style="margin: 0;">Let AI analyze your existing pages to intelligently fill in the Site Information fields below. Select the pages that best represent your business (About, Services, Home, etc.).</p>
			</div>
			
			<div style="margin-bottom: 15px;">
				<label style="font-weight: 600; display: block; margin-bottom: 10px;">Select Pages for AI Analysis:</label>
				<div id="rpm_page_selector" style="max-height: 200px; overflow-y: auto; border: 1px solid #ddd; padding: 10px; border-radius: 4px; background: #f9f9f9;">
					<?php
					$pages = get_pages(array('sort_column' => 'post_title', 'post_status' => 'publish'));
					if ($pages) {
						foreach ($pages as $page) {
							$checked = in_array($page->ID, array(2, get_option('page_on_front'))) ? 'checked' : ''; // Auto-select homepage
							echo '<label style="display: block; margin-bottom: 8px; cursor: pointer;">';
							echo '<input type="checkbox" name="rpm_analysis_pages[]" value="' . esc_attr($page->ID) . '" ' . $checked . ' /> ';
							echo esc_html($page->post_title);
							echo '</label>';
						}
					} else {
						echo '<p style="color: #666; margin: 0;">No pages found. Create some pages first.</p>';
					}
					?>
				</div>
			</div>
			
			<button type="button" id="rpm_ai_fill_form" class="button button-primary" style="height: 40px;">
				🤖 Intelligently Fill Form with AI
			</button>
			
			<div id="rpm_ai_fill_status" style="margin-top: 15px;"></div>
		</div>
		
		<table class="form-table">
			<tr>
				<th scope="row"><label for="rpm_site_description">Site Description *</label></th>
				<td>
					<textarea id="rpm_site_description" name="rpm_site_description" rows="3" class="large-text"><?php echo esc_textarea( get_option( 'rpm_site_description', '' ) ); ?></textarea>
					<p class="description">Describe your website, business, and what makes it unique. This is the foundation for all AI-generated content.</p>
				</td>
			</tr>
			
			<tr>
				<th scope="row"><label for="rpm_industry">Industry/Niche</label></th>
				<td>
					<input type="text" id="rpm_industry" name="rpm_industry" value="<?php echo esc_attr( get_option( 'rpm_industry', '' ) ); ?>" class="regular-text" />
					<p class="description">Your specific industry or market segment (e.g., "real estate", "tech SaaS", "fitness").</p>
				</td>
			</tr>
		</table>
		
		<h2 class="title">Target Audience</h2>
		<table class="form-table">
			<tr>
				<th scope="row"><label for="rpm_target_audience">Target Audience *</label></th>
				<td>
					<textarea id="rpm_target_audience" name="rpm_target_audience" rows="2" class="large-text"><?php echo esc_textarea( get_option( 'rpm_target_audience', '' ) ); ?></textarea>
					<p class="description">Who is your primary audience? Be specific (age, interests, goals, pain points).</p>
				</td>
			</tr>
		</table>
		
		<h2 class="title">Writing Style & Tone</h2>
		<table class="form-table">
			<tr>
				<th scope="row"><label for="rpm_content_tone">Content Tone</label></th>
				<td>
					<select id="rpm_content_tone" name="rpm_content_tone">
						<option value="">Select tone...</option>
						<?php
						$tones = array(
							'professional' => 'Professional - Formal, business-like',
							'friendly' => 'Friendly & Conversational - Warm, approachable',
							'authoritative' => 'Authoritative & Expert - Commanding, knowledgeable',
							'casual' => 'Casual & Relaxed - Informal, laid-back',
							'enthusiastic' => 'Enthusiastic & Energetic - Excited, motivational',
							'empathetic' => 'Empathetic & Supportive - Understanding, helpful',
							'humorous' => 'Humorous & Entertaining - Light, fun'
						);
						$current_tone = get_option( 'rpm_content_tone', '' );
						foreach ( $tones as $value => $label ) {
							printf( '<option value="%s"%s>%s</option>', 
								esc_attr( $value ),
								selected( $current_tone, $value, false ),
								esc_html( $label )
							);
						}
						?>
					</select>
					<p class="description">The voice and personality of your content.</p>
				</td>
			</tr>
			
			<tr>
				<th scope="row"><label for="rpm_writing_style">Writing Style</label></th>
				<td>
					<select id="rpm_writing_style" name="rpm_writing_style">
						<option value="">Select style...</option>
						<?php
						$styles = array(
							'concise' => 'Concise & Direct - Short, to-the-point',
							'balanced' => 'Balanced - Mix of detail and brevity',
							'detailed' => 'Detailed & Comprehensive - In-depth',
							'storytelling' => 'Storytelling & Narrative - Story-driven',
							'list-based' => 'List-Based & Scannable - Bullets, numbered lists'
						);
						$current_style = get_option( 'rpm_writing_style', '' );
						foreach ( $styles as $value => $label ) {
							printf( '<option value="%s"%s>%s</option>', 
								esc_attr( $value ),
								selected( $current_style, $value, false ),
								esc_html( $label )
							);
						}
						?>
					</select>
					<p class="description">How the content is structured and presented.</p>
				</td>
			</tr>
			
			<tr>
				<th scope="row"><label for="rpm_content_goal">Content Goal</label></th>
				<td>
					<select id="rpm_content_goal" name="rpm_content_goal">
						<option value="">Select goal...</option>
						<?php
						$goals = array(
							'inform' => 'Inform & Educate - Teach something new',
							'entertain' => 'Entertain & Engage - Keep readers interested',
							'persuade' => 'Persuade & Convert - Drive action/sales',
							'inspire' => 'Inspire & Motivate - Motivate change',
							'solve' => 'Solve Problems - Provide solutions'
						);
						$current_goal = get_option( 'rpm_content_goal', '' );
						foreach ( $goals as $value => $label ) {
							printf( '<option value="%s"%s>%s</option>', 
								esc_attr( $value ),
								selected( $current_goal, $value, false ),
								esc_html( $label )
							);
						}
						?>
					</select>
					<p class="description">What should the content achieve?</p>
				</td>
			</tr>
			
			<tr>
				<th scope="row"><label for="rpm_expertise_level">Expertise Level</label></th>
				<td>
					<select id="rpm_expertise_level" name="rpm_expertise_level">
						<option value="">Select level...</option>
						<?php
						$levels = array(
							'beginner' => 'Beginner-Friendly - Simple, avoid jargon',
							'intermediate' => 'Intermediate - Balanced technical depth',
							'advanced' => 'Advanced - Technical, industry-specific'
						);
						$current_level = get_option( 'rpm_expertise_level', '' );
						foreach ( $levels as $value => $label ) {
							printf( '<option value="%s"%s>%s</option>', 
								esc_attr( $value ),
								selected( $current_level, $value, false ),
								esc_html( $label )
							);
						}
						?>
					</select>
					<p class="description">Technical level appropriate for your audience.</p>
				</td>
			</tr>
		</table>
		
		<h2 class="title">Content Configuration</h2>
		<table class="form-table">
			<tr>
				<th scope="row"><label for="rpm_content_length">Content Length</label></th>
				<td>
					<select id="rpm_content_length" name="rpm_content_length">
						<?php
						$lengths = array(
							'short' => 'Short (400-600 words) - Quick reads',
							'medium' => 'Medium (800-1200 words) - Standard posts',
							'long' => 'Long (1500-2000 words) - In-depth articles'
						);
						$current_length = get_option( 'rpm_content_length', 'medium' );
						foreach ( $lengths as $value => $label ) {
							printf( '<option value="%s"%s>%s</option>', 
								esc_attr( $value ),
								selected( $current_length, $value, false ),
								esc_html( $label )
							);
						}
						?>
					</select>
					<p class="description">Target word count for generated content.</p>
				</td>
			</tr>
			
			<tr>
				<th scope="row"><label for="rpm_brand_keywords">SEO Keywords</label></th>
				<td>
					<textarea id="rpm_brand_keywords" name="rpm_brand_keywords" rows="2" class="large-text"><?php echo esc_textarea( get_option( 'rpm_brand_keywords', '' ) ); ?></textarea>
					<p class="description"><strong>⚠️ Order matters!</strong> List keywords from most to least important. AI will prioritize earlier keywords more frequently. Example: "primary keyword, secondary keyword, supporting term"</p>
				</td>
			</tr>
			
			<tr>
				<th scope="row"><label for="rpm_avoid_words">Words to Avoid</label></th>
				<td>
					<textarea id="rpm_avoid_words" name="rpm_avoid_words" rows="2" class="large-text"><?php echo esc_textarea( get_option( 'rpm_avoid_words', '' ) ); ?></textarea>
					<p class="description">Words, phrases, or topics the AI should avoid using (comma-separated).</p>
				</td>
			</tr>
			
			<tr>
				<th scope="row"><label for="rpm_image_search">Image Search Preference</label></th>
				<td>
					<input type="text" id="rpm_image_search" name="rpm_image_search" value="<?php echo esc_attr( get_option( 'rpm_image_search', '' ) ); ?>" class="regular-text" placeholder="e.g., red apple on table, kids on bus" />
					<p class="description">💡 <strong>Hint:</strong> Keep it simple with 3-4 words describing the type of images you want (e.g., "modern office desk", "happy family home", "fresh vegetables"). Leave blank and AI will automatically find relevant images based on your content.</p>
				</td>
			</tr>
			
			<tr>
				<th scope="row"><label for="rpm_default_status">Post Status</label></th>
				<td>
					<select id="rpm_default_status" name="rpm_default_status">
						<?php
						$statuses = array(
							'draft' => 'Draft - Save as draft',
							'pending' => 'Pending Review - Requires approval before publishing',
							'publish' => 'Publish - Immediately publish to site'
						);
						$current_status = get_option( 'rpm_default_status', 'pending' );
						foreach ( $statuses as $value => $label ) {
							printf( '<option value="%s"%s>%s</option>', 
								esc_attr( $value ),
								selected( $current_status, $value, false ),
								esc_html( $label )
							);
						}
						?>
					</select>
					<p class="description">Status for auto-generated posts. <strong>Recommended:</strong> Pending Review</p>
				</td>
			</tr>
			
			<tr>
				<th scope="row"><label for="rpm_default_category">Category</label></th>
				<td>
					<select id="rpm_default_category" name="rpm_default_category">
						<option value="">🎲 Random category</option>
						<?php
						$categories = get_categories( array( 'hide_empty' => false ) );
						$current_category = get_option( 'rpm_default_category', '' );
						foreach ( $categories as $category ) {
							printf( '<option value="%s"%s>%s</option>', 
								esc_attr( $category->term_id ),
								selected( $current_category, $category->term_id, false ),
								esc_html( $category->name )
							);
						}
						?>
					</select>
					<p class="description">Category for auto-generated posts. Leave blank to use no category.</p>
				</td>
			</tr>
			
			<tr>
				<th scope="row"><label for="rpm_marketing_mode">Marketing Mode</label></th>
				<td>
					<label>
						<input type="checkbox" id="rpm_marketing_mode" name="rpm_marketing_mode" value="1" <?php checked( get_option( 'rpm_marketing_mode', false ), true ); ?> />
						<strong>Enable persuasive, action-oriented content</strong>
					</label>
					<p class="description">When enabled, content will be more persuasive with clear marketing intent and benefit-focused messaging. The AI will maintain your specified tone while weaving marketing elements throughout.</p>
				</td>
			</tr>
		</table>
		
		<?php submit_button( 'Save Settings' ); ?>
	</form>
</div>

<style>
.rpm-info-card {
	background: #fff;
	border: 1px solid #c3c4c7;
	border-radius: 4px;
	padding: 20px;
	margin: 20px 0;
	box-shadow: 0 1px 1px rgba(0,0,0,0.04);
}
.rpm-info-card h2 {
	margin-top: 0;
	font-size: 18px;
	color: #1d2327;
}
.rpm-info-card ul {
	margin-left: 20px;
}
.rpm-info-footer {
	background: #f9f9f9;
	border: 1px solid #ddd;
	border-radius: 4px;
	padding: 20px;
	margin-top: 0;
	margin-bottom: 30px;
}
.rpm-info-footer h2 {
	margin-top: 0;
}
.rpm-info-footer h3 {
	font-size: 16px;
	margin-bottom: 10px;
}
</style>

<script>
jQuery(document).ready(function($) {
	// AI Form Filler button click handler
	$('#rpm_ai_fill_form').on('click', function() {
		var $button = $(this);
		var $status = $('#rpm_ai_fill_status');
		
		// Get selected pages
		var selectedPages = [];
		$('input[name="rpm_analysis_pages[]"]:checked').each(function() {
			selectedPages.push($(this).val());
		});
		
		// Validation
		if (selectedPages.length === 0) {
			$status.html('<div style="padding: 10px; background: #f8d7da; border-left: 4px solid #d63638; color: #d63638; border-radius: 4px;">Please select at least one page to analyze.</div>');
			return;
		}
		
		// Disable button and show loading
		$button.prop('disabled', true).text('🔄 Analyzing pages with AI...');
		$status.html('<div style="padding: 10px; background: #f0f6fc; border-left: 4px solid #2271b1; color: #2271b1; border-radius: 4px;">⏳ AI is reading your selected pages and generating suggestions...</div>');
		
		// Make AJAX request
		$.ajax({
			url: ajaxurl,
			method: 'POST',
			data: {
				action: 'rpm_ai_analyze_pages',
				page_ids: selectedPages,
				_wpnonce: '<?php echo wp_create_nonce('rpm_ai_analyze_pages'); ?>'
			},
			success: function(response) {
				if (response.success && response.data) {
					var data = response.data;
					
					// Fill in the form fields
					if (data.site_description) {
						$('#rpm_site_description').val(data.site_description);
					}
					if (data.industry) {
						$('#rpm_industry').val(data.industry);
					}
					if (data.target_audience) {
						$('#rpm_target_audience').val(data.target_audience);
					}
					if (data.content_tone) {
						$('#rpm_content_tone').val(data.content_tone);
					}
					if (data.writing_style) {
						$('#rpm_writing_style').val(data.writing_style);
					}
					if (data.content_goal) {
						$('#rpm_content_goal').val(data.content_goal);
					}
					if (data.expertise_level) {
						$('#rpm_expertise_level').val(data.expertise_level);
					}
					if (data.brand_keywords) {
						$('#rpm_brand_keywords').val(data.brand_keywords);
					}
					if (data.avoid_words) {
						$('#rpm_avoid_words').val(data.avoid_words);
					}
					
					// Show success message
					var html = '<div style="padding: 15px; background: #d5f4e6; border-left: 4px solid #00a32a; color: #00a32a; border-radius: 4px;">';
					html += '<strong>✅ Success!</strong> AI has analyzed your pages and filled in the form below.<br>';
					html += '<small>Review the suggestions and adjust as needed, then click "Save Settings" at the bottom.</small>';
					html += '</div>';
					$status.html(html);
					
					// Scroll to first filled field
					$('html, body').animate({
						scrollTop: $('#rpm_site_description').offset().top - 100
					}, 500);
				} else {
					var errorMsg = response.data && response.data.message ? response.data.message : 'Failed to analyze pages';
					$status.html('<div style="padding: 10px; background: #f8d7da; border-left: 4px solid: #d63638; color: #d63638; border-radius: 4px;">❌ Error: ' + errorMsg + '</div>');
				}
			},
			error: function(xhr, status, error) {
				var errorMsg = 'Failed to connect to AI service';
				
				if (status === 'timeout') {
					errorMsg = 'Request timeout - AI analysis took too long';
				} else if (xhr.responseJSON && xhr.responseJSON.data) {
					errorMsg = xhr.responseJSON.data;
				}
				
				$status.html('<div style="padding: 10px; background: #f8d7da; border-left: 4px solid #d63638; color: #d63638; border-radius: 4px;">❌ Error: ' + errorMsg + '</div>');
			},
			complete: function() {
				$button.prop('disabled', false).text('🤖 Intelligently Fill Form with AI');
			}
		});
	});
});
</script>
